function [header,dirnames] = propstats_auto(dir_tmp1,dir_tmp2,header,collate)
%function for running propstats in a narrow but automated fashion.
%Synatax:   [] = propstats();
%Input:     dir_tmp1 = Directory of properties
%           dir_tmp2 = output directory
%           header = a number indicating the number of the output files,
%               default = 0
%           collate = run collate function, default = 0, off
%Output:    header = header number
%           dirnames = processed directory names
if nargin==0||isempty(dir_tmp1)||isempty(dir_tmp2)
    dir_tmp1 = uigetdir2('','Directory of properties');    %get the directory
    dir_tmp2 = uigetdir3('','Output Directory');
end
if nargin<3||isempty(header)
    header = 0;
end
if nargin<4
    collate = 0;
end

%get only the directory names
dir_struct = dir(dir_tmp1);  %grab the directory information
idx = [dir_struct.isdir];   %grab all of the isdir numbers
names = {dir_struct.name};   %grab the all of the names in the root
dirnames = names(idx);

%create output directories
mkdir(dir_tmp2,'layer4');
mkdir(dir_tmp2,'layer5');

for i = 3:size(dirnames,2)  %go through each directory
    header = header+1;  %iterate first
    %save the file with 00 padding
    if header<10   %double pad
        h = ['00',num2str(header)];
    elseif header<100  %single pad
        h = ['0',num2str(header)];
    else        %no pad
        h = num2str(header);
    end
    %we make lots of assumptions (With our without aprop)
    propstats([dir_tmp1,filesep,dirnames{i},filesep,'KO\Layer4\aprop\joined_prop\'],[dir_tmp1,filesep,dirnames{i},filesep,'WT\Layer4\aprop\joined_prop\'],[h,'_']);
    propstats([dir_tmp1,filesep,dirnames{i},filesep,'KO\Layer5\aprop\joined_prop\'],[dir_tmp1,filesep,dirnames{i},filesep,'WT\Layer5\aprop\joined_prop\'],[h,'_']);
    %copy files over
    %layer4
    dir_struct = dir([dir_tmp1,filesep,dirnames{i},filesep,'KO\Layer4\aprop\joined_prop\propstats\']);  %grab the directory information
    idx = [dir_struct.isdir];   %grab all of the isdir numbers
    names = {dir_struct.name};   %grab the all of the names in the root
    file_list = names(~idx);
    copyfiles([dir_tmp1,filesep,dirnames{i},filesep,'KO\Layer4\aprop\joined_prop\propstats\'],[dir_tmp2,filesep,'layer4'],file_list);
    %layer5
    dir_struct = dir([dir_tmp1,filesep,dirnames{i},filesep,'KO\Layer5\aprop\joined_prop\propstats\']);  %grab the directory information
    idx = [dir_struct.isdir];   %grab all of the isdir numbers
    names = {dir_struct.name};   %grab the all of the names in the root
    file_list = names(~idx);
    copyfiles([dir_tmp1,filesep,dirnames{i},filesep,'KO\Layer5\aprop\joined_prop\propstats\'],[dir_tmp2,filesep,'layer5'],file_list);
%     propstats([dir_tmp1,filesep,dirnames{i},filesep,'KO\Layer4\joined_prop\'],[dir_tmp1,filesep,dirnames{i},filesep,'WT\Layer4\joined_prop\'],[h,'_']);
%     propstats([dir_tmp1,filesep,dirnames{i},filesep,'KO\Layer5\joined_prop\'],[dir_tmp1,filesep,dirnames{i},filesep,'WT\Layer5\joined_prop\'],[h,'_']);
%     %copy files over
%     %layer4
%     dir_struct = dir([dir_tmp1,filesep,dirnames{i},filesep,'KO\Layer4\joined_prop\propstats\']);  %grab the directory information
%     idx = [dir_struct.isdir];   %grab all of the isdir numbers
%     names = {dir_struct.name};   %grab the all of the names in the root
%     file_list = names(~idx);
%     copyfiles([dir_tmp1,filesep,dirnames{i},filesep,'KO\Layer4\joined_prop\propstats\'],[dir_tmp2,filesep,'layer4'],file_list);
%     %layer5
%     dir_struct = dir([dir_tmp1,filesep,dirnames{i},filesep,'KO\Layer5\joined_prop\propstats\']);  %grab the directory information
%     idx = [dir_struct.isdir];   %grab all of the isdir numbers
%     names = {dir_struct.name};   %grab the all of the names in the root
%     file_list = names(~idx);
%     copyfiles([dir_tmp1,filesep,dirnames{i},filesep,'KO\Layer5\joined_prop\propstats\'],[dir_tmp2,filesep,'layer5'],file_list);
end

dirdata = dataset(char(dirnames));
sav2csv(dirdata,['dirnames',datestr(now,30),'.csv'],[dir_tmp2]);

%collate if you want
if collate
    %Now sort through the directory
    [filenames1] = dir_sort([dir_tmp2,filesep,'layer4']);
    [filenames2] = dir_sort([dir_tmp2,filesep,'layer5']);
    %layer 4
    mkdir(dir_tmp2,'collatedlayer4');
    for j = 1:size(filenames1,2)    %go through the files, each group a property
        filename_tmp = filenames1{j};
        prop_data1 = [];
        for n = 1:size(filename_tmp,1)
            prop_tmp1 = single(dlmread([dir_tmp2,filesep,'layer4',filesep,filename_tmp(n,:)],',',1,1));
            prop_data1 = horzcat(prop_data1,reshape(prop_tmp1,size(prop_tmp1,1),1,size(prop_tmp1,2)));
        end
        %now save out the data file
        filename_tmp = cellstr(filename_tmp);
        for l = 1:size(prop_data1,3)     %save each column independently
            dataout = dataset({prop_data1(:,:,l),filename_tmp{:}});
            sav2csv(dataout,[num2str(j),'collated',num2str(l),'prop.csv'],[dir_tmp2,'\collatedlayer4']);
        end
    end
    %Layer5
    mkdir(dir_tmp2,'collatedlayer5');
    for k = 1:size(filenames2,2)
        filename_tmp = filenames2{k};
        prop_data2 = [];
        for n = 1:size(filename_tmp,1)
            prop_tmp2 = single(dlmread([dir_tmp2,filesep,'layer5',filesep,filename_tmp(n,:)],',',1,1));
            prop_data2 = horzcat(prop_data2,reshape(prop_tmp2,size(prop_tmp2,1),1,size(prop_tmp2,2)));
        end
        %now save out the data file
        filename_tmp = cellstr(filename_tmp);
        for m = 1:size(prop_data2,3)     %save each column independently
            dataout = dataset({prop_data2(:,:,m),filename_tmp{:}});
            sav2csv(dataout,[num2str(k),'collated',num2str(m),'prop.csv'],[dir_tmp2,'\collatedlayer5']);
        end
    end
end

%-----------------------------------------------------------------------------------------------------------------------------
function [filenames_out] = dir_sort(dir_tmp)
%give the directory and it will sort out the files in it and put a cell
%array of filenames
dir_struct = dir(dir_tmp);  %grab the directory information
idx = [dir_struct.isdir];   %grab all of the isdir numbers
names = {dir_struct.name};   %grab the all of the names in the root
filenames = names(~idx);
%filename_tmp = filename_tmp(3:end,:);
for i = 1:size(filenames,2)      %step through each filename and pull the wanted word
    filename_tmp = filenames{i};
    strmask = isstrprop(filename_tmp,'punct');  %find the punctuations, we only want the last two
    strmask2 = filename_tmp=='&';       %we are going to exempt the & character
    strmask3 = isstrprop(filename_tmp,'wspace');    %included the spaces as well
    strmask = strmask-strmask2+strmask3;     %removed and append
    [x,y] = find(strmask==1);  %get the positions
    %all we need is the numbers in front
    h_tmp{i,:} = filename_tmp(1,y(1)+1);
end
uq_header = unique(h_tmp);
for l = 1:size(uq_header,1)
    tmp = [];
    for k = 1:size(h_tmp,1)     %step through the all file names
        if strcmpi(uq_header(l,:),h_tmp(k,:)) %if there is a match (case insensitive now)
            tmp = vertcat(tmp,filenames(k));  %put it in the current file names temp
        end
    end
    filenames_out{l} = char(tmp);
end
%--------------------------------------------------------------------------
function [] = copyfiles(dir_tmp,out_tmp,file_list)
%Move all of the files from one directory to another
for i = 1:size(file_list,2);
    copyfile([dir_tmp,filesep,file_list{i}],out_tmp);
end